package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class StudentPlayMonthTotalRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.StudentPlayMonthTotal MONTH = Tables.STUDENT_PLAY_MONTH_TOTAL;
	private static final com.jz.jooq.media.tables.StudentPlayMonthTagTotal TAG = Tables.STUDENT_PLAY_MONTH_TAG_TOTAL;

	public void refreshPlayTotal(BrandEnum brand, String suid, String month, int playTime, int videoCnt) {
		long timeMillis = System.currentTimeMillis();
		mediaCtx.insertInto(MONTH, MONTH.BRAND, MONTH.SUID, MONTH.MONTH, MONTH.PLAY_TIME, MONTH.VIDEO_CNT,
				MONTH.CREATE_TIME, MONTH.LAST_UPDATE)
				.values(brand.name(), suid, month, playTime, videoCnt, timeMillis, timeMillis).onDuplicateKeyUpdate()
				.set(MONTH.PLAY_TIME, MONTH.PLAY_TIME.add(playTime)).set(MONTH.VIDEO_CNT, MONTH.VIDEO_CNT.add(videoCnt))
				.set(MONTH.LAST_UPDATE, timeMillis).execute();
	}

	public void refreshTagPlayTotal(BrandEnum brand, String suid, String month, List<String> tags, int playTime,
			int videoCnt) {
		long timeMillis = System.currentTimeMillis();
		StringBuffer sb = new StringBuffer();
		sb.append("INSERT INTO `student_play_month_tag_total` ");
		sb.append("(`brand`, `suid`, `tag`, `month`, `play_time`, `video_cnt`, `create_time`, `last_update`)");
		sb.append(" VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
		sb.append("ON DUPLICATE KEY UPDATE `play_time` = `play_time` + ?, `video_cnt` = `video_cnt` + ?, `last_update` = ?");
		List<Object[]> batchArgs = Lists.newArrayList();
		for (String tag : tags) {
			batchArgs.add(new Object[] { brand.name(), suid, tag, month, playTime, videoCnt, timeMillis, timeMillis,
					playTime, videoCnt, timeMillis });
		}
		mediaJdbcTemplate.batchUpdate(sb.toString(), batchArgs);
	}
}
