package com.jz.jar.media.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.StudentPlayMonthTotalRepository;

@Lazy
@Service
public class StudentPlayMonthTotalService {

	@Autowired
	private StudentPlayMonthTotalRepository studentPlayMonthTotalRepository;

	public void refreshPlayTotal(BrandEnum brand, String suid, String month, int playLength, int videoCnt) {
		studentPlayMonthTotalRepository.refreshPlayTotal(brand, suid, month, playLength, videoCnt);
	}

	public void refreshTagPlayTotal(BrandEnum brand, String suid, String month, List<String> tags, int playLength,
			int videoCnt) {
		studentPlayMonthTotalRepository.refreshTagPlayTotal(brand, suid, month, tags, playLength, videoCnt);
	}
}
