package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.WorksThemeRepository;
import com.jz.jooq.media.tables.pojos.WorksTheme;

@Lazy
@Service
public class WorksThemeService {

	@Autowired
	private WorksThemeRepository worksThemeRepository;

	public int countOnlineWorksTheme() {
		return worksThemeRepository.countOnlineWorksTheme();
	}

	public List<String> getOnlineWorksThemeIds(int start, int size) {
		return worksThemeRepository.getOnlineWorksThemeIds(start, size);
	}

	public List<WorksTheme> findWorksThemeInfo(Collection<String> ids) {
		return worksThemeRepository.findWorksThemeInfo(ids);
	}

	public void addWorksCnt(Collection<String> ids, int cnt) {
		worksThemeRepository.addWorksCnt(ids, cnt);
	}
}
