package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class WorksLikeRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.WorksLike WL = Tables.WORKS_LIKE;

	public int countForWorkId(String id) {
		return mediaCtx.fetchCount(WL, WL.WORK_ID.eq(id));
	}

	public int countForWorkId(Collection<String> ids) {
		return mediaCtx.fetchCount(WL, WL.WORK_ID.in(ids));
	}

	public Map<String, Integer> getLikeCount(Collection<String> workIds) {
		List<Map<String, Object>> rows = mediaCtx.select(WL.WORK_ID, DSL.count(WL.PUID).as("ct")).from(WL)
				.where(WL.WORK_ID.in(workIds)).groupBy(WL.WORK_ID).fetchMaps();
		if (ArrayMapTools.isEmpty(rows))
			return Maps.newHashMap();
		Map<String, Integer> workId2Cnt = Maps.newHashMap();
		for (Map<String, Object> has : rows) {
			if (ArrayMapTools.containsKeys(has, "art_id", "ct")) {
				workId2Cnt.put(MapUtils.getString(has, "art_id"), MapUtils.getInteger(has, "ct"));
			}
		}
		return workId2Cnt;
	}

	public boolean existForIdAndUid(String id, String puid) {
		return mediaCtx.fetchExists(WL, WL.WORK_ID.eq(id).and(WL.PUID.eq(puid)));
	}

	public List<String> screenLike(Collection<String> workIds, String puid) {
		return mediaCtx.select(WL.WORK_ID).from(WL).where(WL.WORK_ID.in(workIds).and(WL.PUID.eq(puid)))
				.fetchInto(String.class);
	}

	public void addWorkLike(String workId, String puid) {
		mediaCtx.insertInto(WL, WL.WORK_ID, WL.PUID, WL.CREATE_TIME).values(workId, puid, System.currentTimeMillis())
				.onDuplicateKeyIgnore().execute();
	}

	public void deleteWorkLike(String workId) {
		mediaCtx.deleteFrom(WL).where(WL.WORK_ID.eq(workId)).execute();
	}

	public void deleteWorkLike(String workId, String puid) {
		mediaCtx.deleteFrom(WL).where(WL.WORK_ID.eq(workId).and(WL.PUID.eq(puid))).execute();
	}

	public int countMyLike(String puid) {
		return mediaCtx.fetchCount(WL, WL.PUID.eq(puid));
	}

	public List<String> getMyLike(String puid, int start, int size) {
		return mediaCtx.select(WL.WORK_ID).from(WL).where(WL.PUID.eq(puid)).orderBy(WL.CREATE_TIME.desc())
				.limit(start, size).fetchInto(String.class);
	}
}
