package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.PlaylistRepository;
import com.jz.jooq.media.tables.pojos.Playlist;

/**
 * @Title PlaylistService
 * @Package com.jz.jar.media.service
 * @author tangjunfeng
 * @date 2018年8月2日 上午9:58:54
 * @version V1.0
 */
@Lazy
@Service
public class PlaylistService {

	@Autowired
	private PlaylistRepository playlistRepository;

	public Playlist getOnlinePlaylist(String pid, BrandEnum brand) {
		return playlistRepository.getOnlinePlaylist(pid, brand);
	}

	public List<Playlist> getOnlinePlaylist(Collection<String> pids, BrandEnum brand) {
		return playlistRepository.getOnlinePlaylist(pids, brand);
	}

	public Map<String, Integer> getPlaylistToVideoCount(Collection<String> pids) {
		return playlistRepository.getPlaylistToVideoCount(pids);
	}

	public String getWidForPlaylist(String pid) {
		return playlistRepository.getWidForPlaylist(pid);
	}
}
