package com.jz.jar.media.repository;

import java.util.List;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.CommentType;
import com.jz.jar.media.enums.SourceStatus;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.CommentInfo;
import com.jz.jooq.media.tables.records.CommentInfoRecord;

@Lazy
@Repository
public class CommentInfoRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.CommentInfo CI = Tables.COMMENT_INFO;

	public void addComment(BrandEnum brand, String id, CommentType type, String sourceId, String uid, String content) {
		CommentInfoRecord record = new CommentInfoRecord();
		record.setId(id);
		record.setBrand(brand.name());
		record.setSourceType(type.name());
		record.setSourceId(sourceId);
		record.setUid(uid);
		record.setContent(content);
		record.setStatus(SourceStatus.verifying.getCode());
		long timeMillis = System.currentTimeMillis();
		record.setCreateTime(timeMillis);
		record.setLastUpdate(timeMillis);
		mediaCtx.insertInto(CI).set(record).execute();
	}

	private Condition getCondition(BrandEnum brand, CommentType type, String sourceId) {
		return CI.BRAND.eq(brand.name()).and(CI.SOURCE_TYPE.eq(type.name())).and(CI.SOURCE_ID.eq(sourceId))
				.and(CI.STATUS.in(SourceStatus.verifying.getCode(), SourceStatus.online.getCode()));
	}

	public int countCommentInfo(BrandEnum brand, CommentType type, String sourceId) {
		return mediaCtx.fetchCount(CI, getCondition(brand, type, sourceId));
	}

	public List<CommentInfo> getCommentInfo(BrandEnum brand, CommentType type, String sourceId, int start, int size) {
		return mediaCtx.select(CI.ID, CI.UID, CI.CONTENT, CI.CREATE_TIME).from(CI)
				.where(getCondition(brand, type, sourceId)).orderBy(CI.CREATE_TIME.desc()).limit(start, size)
				.fetchInto(CommentInfo.class);
	}

	public CommentInfo getCommentInfo(BrandEnum brand, String id) {
		return mediaCtx.selectFrom(CI).where(CI.ID.eq(id).and(CI.BRAND.eq(brand.name())))
				.fetchAnyInto(CommentInfo.class);
	}
}
