/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserCollectVideo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserCollectVideoRepository
extends MediaBaseRepository {
    private static final com.jz.jooq.media.tables.UserCollectVideo UCV = Tables.USER_COLLECT_VIDEO;

    public void addCollect(String uid, String pid, String wid) {
        this.mediaCtx.insertInto((Table)UCV, (Field)UserCollectVideoRepository.UCV.UID, (Field)UserCollectVideoRepository.UCV.PID, (Field)UserCollectVideoRepository.UCV.WID, (Field)UserCollectVideoRepository.UCV.CREATE_TIME).values((Object)uid, (Object)pid, (Object)wid, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public List<UserCollectVideo> getCollect(String uid) {
        return this.mediaCtx.selectFrom((Table)UCV).where(new Condition[]{UserCollectVideoRepository.UCV.UID.eq((Object)uid)}).orderBy(UserCollectVideoRepository.UCV.CREATE_TIME.desc()).fetchInto(UserCollectVideo.class);
    }

    public int countCollectForUser(String uid) {
        return this.mediaCtx.fetchCount((Table)UCV, UserCollectVideoRepository.UCV.UID.eq((Object)uid));
    }

    public List<UserCollectVideo> getCollect(String uid, int start, int size) {
        return this.mediaCtx.selectFrom((Table)UCV).where(new Condition[]{UserCollectVideoRepository.UCV.UID.eq((Object)uid)}).orderBy(UserCollectVideoRepository.UCV.CREATE_TIME.desc()).limit(start, size).fetchInto(UserCollectVideo.class);
    }

    public boolean isCollect(String uid, String pid, String wid) {
        return this.mediaCtx.fetchExists((Table)UCV, UserCollectVideoRepository.UCV.UID.eq((Object)uid).and(UserCollectVideoRepository.UCV.PID.eq((Object)pid)).and(UserCollectVideoRepository.UCV.WID.eq((Object)wid)));
    }

    public void deleteCollect(String uid, String pid, String wid) {
        this.mediaCtx.deleteFrom((Table)UCV).where(new Condition[]{UserCollectVideoRepository.UCV.UID.eq((Object)uid).and(UserCollectVideoRepository.UCV.PID.eq((Object)pid)).and(UserCollectVideoRepository.UCV.WID.eq((Object)wid))}).execute();
    }

    public int countCollectForVideo(String wid) {
        return this.mediaCtx.fetchCount((Table)UCV, UserCollectVideoRepository.UCV.WID.eq((Object)wid));
    }

    public Map<String, Integer> countCollectForVideo(Collection<String> wids) {
        List maps = this.mediaCtx.select((SelectField)UserCollectVideoRepository.UCV.WID, (SelectField)DSL.count((Field)UserCollectVideoRepository.UCV.WID).as("ct")).from((TableLike)UCV).where(new Condition[]{UserCollectVideoRepository.UCV.WID.in(wids)}).groupBy(new GroupField[]{UserCollectVideoRepository.UCV.WID}).fetchMaps();
        if (ArrayMapTools.isEmpty((Collection)maps)) {
            return Maps.newHashMap();
        }
        HashMap wid2Cnt = Maps.newHashMap();
        maps.forEach(it -> {
            if (ArrayMapTools.isEmpty((Map)it) || !ArrayMapTools.containsKeys((Map)it, (String[])new String[]{"wid", "ct"})) {
                return;
            }
            it.forEach((_w, _ct) -> wid2Cnt.put(_w, Integer.parseInt(_ct.toString())));
        });
        return wid2Cnt;
    }
}

