/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.ArtLike;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class ArtLikeRepository
extends MediaBaseRepository {
    private static final ArtLike AK = Tables.ART_LIKE;

    public int countForArtId(String id) {
        return this.mediaCtx.fetchCount((Table)AK, ArtLikeRepository.AK.ART_ID.eq((Object)id));
    }

    public Map<String, Integer> getLikeCount(Collection<String> artIds) {
        List rows = this.mediaCtx.select((SelectField)ArtLikeRepository.AK.ART_ID, (SelectField)DSL.count((Field)ArtLikeRepository.AK.PUID).as("ct")).from((TableLike)AK).where(new Condition[]{ArtLikeRepository.AK.ART_ID.in(artIds)}).groupBy(new GroupField[]{ArtLikeRepository.AK.ART_ID}).fetchMaps();
        if (ArrayMapTools.isEmpty((Collection)rows)) {
            return Maps.newHashMap();
        }
        HashMap artId2Cnt = Maps.newHashMap();
        for (Map has : rows) {
            if (!ArrayMapTools.containsKeys((Map)has, (String[])new String[]{"puid", "ct"})) continue;
            artId2Cnt.put(has.get("puid").toString(), MapUtils.getInteger((Map)has, (Object)"ct"));
        }
        return artId2Cnt;
    }

    public boolean existForIdAndUid(String id, String puid) {
        return this.mediaCtx.fetchExists((Table)AK, ArtLikeRepository.AK.ART_ID.eq((Object)id).and(ArtLikeRepository.AK.PUID.eq((Object)puid)));
    }

    public List<String> screenLike(Collection<String> artIds, String puid) {
        return this.mediaCtx.select((SelectField)ArtLikeRepository.AK.ART_ID).from((TableLike)AK).where(new Condition[]{ArtLikeRepository.AK.ART_ID.in(artIds).and(ArtLikeRepository.AK.PUID.eq((Object)puid))}).fetchInto(String.class);
    }

    public void addArtLike(String artId, String puid) {
        this.mediaCtx.insertInto((Table)AK, (Field)ArtLikeRepository.AK.ART_ID, (Field)ArtLikeRepository.AK.PUID, (Field)ArtLikeRepository.AK.CREATE_TIME).values((Object)artId, (Object)puid, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public void deleteArtLike(String artId, String puid) {
        this.mediaCtx.deleteFrom((Table)AK).where(new Condition[]{ArtLikeRepository.AK.ART_ID.eq((Object)artId).and(ArtLikeRepository.AK.PUID.eq((Object)puid))}).execute();
    }
}

