package com.jz.jar.media.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.ArtInfoRepository;

/**
 * @Title ArtThemeRelationService
 * @Package com.jz.jar.media.service
 * @author tangjunfeng
 * @date 2019年1月14日 下午2:40:48
 * @version V1.0
 */
@Lazy
@Service
public class ArtThemeRelationService {

	@Autowired
	private ArtInfoRepository artInfoRepository;

	public int countArts(BrandEnum brand, String themeId) {
		return artInfoRepository.countArts(brand, themeId);
	}

	public List<String> getArtIds(BrandEnum brand, String themeId, boolean isHot, int start, int size) {
		return artInfoRepository.getArtIds(brand, themeId, isHot, start, size);
	}
}
