package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.SourceStatus;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.ArtTheme;

@Lazy
@Repository
public class ArtThemeRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.ArtTheme AT = Tables.ART_THEME;

	public int countOnlineArtTheme() {
		return mediaCtx.fetchCount(AT, AT.STATUS.eq(SourceStatus.online.getCode()));
	}

	public List<String> getOnlineArtThemeIds(int start, int size) {
		return mediaCtx.select(AT.ID).from(AT).where(AT.STATUS.eq(SourceStatus.online.getCode())).orderBy(AT.SEQ.desc())
				.limit(start, size).fetchInto(String.class);
	}

	public List<ArtTheme> findArtThemeInfo(Collection<String> ids) {
		return mediaCtx.selectFrom(AT).where(AT.ID.in(ids)).orderBy(AT.SEQ.desc()).fetchInto(ArtTheme.class);
	}

}
