package com.jz.jar.media.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class ArtLikeRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.ArtLike AK = Tables.ART_LIKE;

	public int countForArtId(String id) {
		return mediaCtx.fetchCount(AK, AK.ART_ID.eq(id));
	}

	public boolean existForIdAndUid(String id, String puid) {
		return mediaCtx.fetchExists(AK, AK.ART_ID.eq(id).and(AK.PUID.eq(puid)));
	}
}
