package com.jz.jar.media.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.ArtInfo;

@Lazy
@Repository
public class ArtInfoRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.ArtInfo AI = Tables.ART_INFO;

	public ArtInfo getArtInfo(String id, BrandEnum brand) {
		return mediaCtx.selectFrom(AI).where(AI.ID.eq(id)).fetchAnyInto(ArtInfo.class);
	}

}
