package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.repository.AiRepository;
import com.jz.jar.media.wrapper.AiPackCampWrapper;
import com.jz.jooq.media.tables.pojos.AiLesson;
import com.jz.jooq.media.tables.pojos.AiLessonSection;
import com.jz.jooq.media.tables.pojos.AiLessonSectionMaterial;
import com.jz.jooq.media.tables.pojos.AiMaterial;
import com.jz.jooq.media.tables.pojos.AiPackCamp;
import com.jz.jooq.media.tables.pojos.AiPackSerie;

@Lazy
@Service
public class AiService {

	@Autowired
	private AiRepository aiRepository;
	@Autowired
	private UserAiService userAiService;

	public AiLesson getLesson(String aid) {
		return aiRepository.getLesson(aid);
	}

	public List<AiLesson> mutiGetOnlineLesson(Collection<String> aids) {
		return aiRepository.mutiGetOnlineLesson(aids);
	}

	public List<AiLessonSection> getAiSections(String aid) {
		return aiRepository.getAiSections(aid);
	}

	public List<String> getAiSectionIds(String aid) {
		return aiRepository.getAiSectionIds(aid);
	}

	public List<AiLessonSectionMaterial> getAiMaterials(String aid) {
		return aiRepository.getAiMaterials(aid);
	}

	public List<String> getAiMaterialIdsInSection(String aid, String sectionId) {
		return aiRepository.getAiMaterialIdsInSection(aid, sectionId);
	}

	public List<AiMaterial> mutiGetOnlineMaterials(Collection<String> ids) {
		return aiRepository.mutiGetOnlineMaterials(ids);
	}

	public List<AiPackSerie> getSeries(String pid) {
		return aiRepository.getSeries(pid);
	}

	public List<AiPackCampWrapper> getJoinAbleCampsTimeName(String pid, boolean isAll, int size) {
		List<AiPackCamp> camps = aiRepository.getJoinAbleCampsTimeName(pid);
		if (ArrayMapTools.isEmpty(camps)) {
			return null;
		}
		Map<Long, Integer> campUser = userAiService.cntCampUser(pid);
		List<AiPackCampWrapper> list = Lists.newArrayList();
		for (AiPackCamp c : camps) {
			AiPackCampWrapper w = AiPackCampWrapper.of(c);
			if (campUser.containsKey(c.getOpenTime())) {
				if (!isAll && c.getMaxNum() <= campUser.get(c.getOpenTime())) {
					continue;
				} else {
					w.setLeftNum(c.getMaxNum() - campUser.get(c.getOpenTime()));
				}
			} else {
				w.setLeftNum(c.getMaxNum());
			}
			list.add(w);
		}
		return list.subList(0, Math.min(list.size(), size));
	}

	public Long getRecentJoinAbleCamp(String pid) {
		return aiRepository.getRecentJoinAbleCamp(pid);
	}

	public AiPackCamp getCamp(String pid, long openTime) {
		return aiRepository.getCamp(pid, openTime);
	}

	public Map<Integer, Long> getCampLessonTimeMap(String pid, long openTime) {
		return aiRepository.getCampLessonTimeMap(pid, openTime);
	}

	public Long getLessonTime(String pid, Long openTime, int seq) {
		return aiRepository.getLessonTime(pid, openTime, seq);
	}

	public AiPackSerie getserie(String pid, String serieId) {
		return aiRepository.getSerie(pid, serieId);
	}

	public List<String> getAiLessonMaterialIds(String aid, Collection<String> materialIds) {
		return aiRepository.getAiLessonMaterialIds(aid, materialIds);
	}

	public List<String> filterMaterialIdsByType(Collection<String> materialIds, String type) {
		return aiRepository.filterMaterialIdsByType(materialIds, type);
	}

	public String getMaterialTypeById(String id) {
		return aiRepository.getMaterialTypeById(id);
	}
}
