package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserNotice;
import com.jz.jooq.media.tables.records.UserNoticeRecord;

@Lazy
@Repository
public class UserNoticeRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserNotice UN = Tables.USER_NOTICE;

	public void addUserNotice(UserNoticeRecord... records) {
		mediaCtx.batchInsert(records).execute();
	}

	public int countUnreadNotices(BrandEnum brand, String uid, long timestamp) {
		return mediaCtx.fetchCount(UN, UN.UID.eq(uid).and(UN.BRAND.eq(brand.name())).and(UN.CREATED.gt(timestamp)));
	}

	public int countNotices(BrandEnum brand, String uid) {
		return mediaCtx.fetchCount(UN, UN.UID.eq(uid).and(UN.BRAND.eq(brand.name())));
	}

	public List<UserNotice> findNotices(BrandEnum brand, String uid, int start, int size) {
		return mediaCtx.selectFrom(UN).where(UN.UID.eq(uid).and(UN.BRAND.eq(brand.name()))).orderBy(UN.CREATED.desc())
				.limit(start, size).fetchInto(UserNotice.class);
	}
}
