package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.UserPlayHistoryRepository;
import com.jz.jooq.media.tables.pojos.UserPlayHistory;

@Lazy
@Service
public class UserPlayHistoryService {

	@Autowired
	private UserPlayHistoryRepository userPlayHistoryRepository;

	public void save(String uid, String pid, String wid, int playLength, String nextWid) {
		userPlayHistoryRepository.save(uid, pid, wid, playLength, nextWid);
	}

	public int countPlayHistory(String uid) {
		return userPlayHistoryRepository.countPlayHistory(uid);
	}

	public List<UserPlayHistory> getPlayHistory(String uid, int start, int size) {
		return userPlayHistoryRepository.getPlayHistory(uid, start, size);
	}

	public void deleteHistory(String uid, String pid) {
		userPlayHistoryRepository.deleteHistory(uid, pid);
	}

	public void deleteHistory(String uid, int cnt) {
		userPlayHistoryRepository.deleteHistory(uid, cnt);
	}

	public UserPlayHistory getHistory(String uid, String pid) {
		return userPlayHistoryRepository.getHistory(uid, pid);
	}

	public List<UserPlayHistory> getHistories(String uid, Collection<String> pidArray) {
		return userPlayHistoryRepository.getHistories(uid, pidArray);
	}

	public List<String> getHistoryPids(String uid) {
		return userPlayHistoryRepository.getHistoryPids(uid);
	}

}
