/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.service;

import com.jz.common.redis.auto.cache.annotation.definition.THashCache;
import com.jz.common.redis.auto.cache.annotation.types.hash.THash;
import com.jz.jar.media.repository.PlaylistRepository;
import com.jz.jooq.media.tables.pojos.Playlist;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
@THashCache(clazz=Playlist.class, keyFieldName="pid", keyPrefix="playlist:")
public class PlaylistService {
    @Autowired
    private PlaylistRepository playlistRepository;

    @THash(keyArgsIndex=0)
    public Playlist getOnlinePlaylist(String pid) {
        return this.playlistRepository.getOnlinePlaylist(pid);
    }

    @THash(keyArgsIndex=0)
    public List<Playlist> getOnlinePlaylist(Collection<String> pids) {
        return this.playlistRepository.getOnlinePlaylist(pids);
    }

    public Map<String, Integer> getPlaylistToVideoCount(Collection<String> pids) {
        return this.playlistRepository.getPlaylistToVideoCount(pids);
    }
}

