package com.jz.jar.media.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.WorksVideo;
import com.jz.jooq.media.tables.records.WorksAuthorRecord;

@Lazy
@Repository
public class WorksVideoRepository extends MediaBaseRepository implements BaseConditionRepository<WorksAuthorRecord> {

	private static final com.jz.jooq.media.tables.WorksVideo WV = Tables.WORKS_VIDEO;

	public WorksVideo getVideo(String wid) {
		return mediaCtx.selectFrom(WV).where(WV.WID.eq(wid)).fetchAnyInto(WorksVideo.class);
	}

}
