package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserSignDaySetting;
import com.jz.jooq.media.tables.pojos.UserSignMonthSetting;

@Repository
public class UserSignTaskRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserSignDaySetting USDS = Tables.USER_SIGN_DAY_SETTING;
	private static final com.jz.jooq.media.tables.UserSignMonthSetting USMS = Tables.USER_SIGN_MONTH_SETTING;

	public List<UserSignDaySetting> getDaySettings(String brand, String month) {
		return mediaCtx.selectFrom(USDS).where(USDS.BRAND.eq(brand).and(USDS.MONTH.eq(month))).orderBy(USDS.DATE.asc())
				.fetchInto(UserSignDaySetting.class);
	}

	public List<UserSignMonthSetting> getAccuSettings(String brand, String month) {
		return mediaCtx.selectFrom(USMS).where(USMS.BRAND.eq(brand).and(USMS.MONTH.eq(month))).orderBy(USMS.DAYS.asc())
				.fetchInto(UserSignMonthSetting.class);
	}

	public UserSignDaySetting getDaySetting(String brand, String date) {
		return mediaCtx.selectFrom(USDS).where(USDS.BRAND.eq(brand).and(USDS.DATE.eq(date)))
				.fetchAnyInto(UserSignDaySetting.class);
	}

	public UserSignMonthSetting getAccuSetting(String brand, String month, int days) {
		return mediaCtx.selectFrom(USMS).where(USMS.BRAND.eq(brand).and(USMS.MONTH.eq(month)).and(USMS.DAYS.eq(days)))
				.fetchAnyInto(UserSignMonthSetting.class);
	}

}
