package com.jz.jar.media.repository;

import java.util.List;

import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserRecomAudition;
import com.jz.jooq.media.tables.pojos.UserRecomContract;

@Lazy
@Repository
public class UserRecomRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserRecomAudition URA = Tables.USER_RECOM_AUDITION;
	private static final com.jz.jooq.media.tables.UserRecomContract URC = Tables.USER_RECOM_CONTRACT;

	public void createAudition(String puid, String brand, String suid, String schoolId, String sourcePuid,
			String sourceType, int num) {
		mediaCtx.insertInto(URA, URA.PUID, URA.BRAND, URA.SUID, URA.SCHOOL_ID, URA.SOURCE_PUID, URA.SOURCE_TYPE,
				URA.NUM, URA.CREATED)
				.values(puid, brand, suid, schoolId, sourcePuid, sourceType, num, System.currentTimeMillis())
				.onDuplicateKeyIgnore().execute();
	}

	public UserRecomAudition getAudition(String puid, String brand) {
		return mediaCtx.selectFrom(URA).where(URA.PUID.eq(puid).and(URA.BRAND.eq(brand)))
				.fetchAnyInto(UserRecomAudition.class);
	}

	public int cntAuditionBySourcePuid(String sourcePuid, String brand) {
		return mediaCtx.fetchCount(URA, URA.SOURCE_PUID.eq(sourcePuid).and(URA.BRAND.eq(brand)));
	}

	public List<UserRecomAudition> getAuditionBySourcePuid(String sourcePuid, String brand, int start, int size) {
		return mediaCtx.selectFrom(URA).where(URA.SOURCE_PUID.eq(sourcePuid).and(URA.BRAND.eq(brand)))
				.orderBy(URA.CREATED.desc()).limit(start, size).fetchInto(UserRecomAudition.class);
	}

	public void createContract(String contractId, String brand, String puid, String schoolId, String childName,
			String sourcePuid, int num) {
		mediaCtx.insertInto(URC, URC.CONTRACT_ID, URC.BRAND, URC.PUID, URC.SCHOOL_ID, URC.CHILD_NAME, URC.SOURCE_PUID,
				URC.NUM, URC.CREATED)
				.values(contractId, brand, puid, schoolId, childName, sourcePuid, num, System.currentTimeMillis())
				.onDuplicateKeyIgnore().execute();
	}

	public UserRecomContract getContract(String contractId, String brand) {
		return mediaCtx.selectFrom(URC).where(URC.CONTRACT_ID.eq(contractId).and(URC.BRAND.eq(brand)))
				.fetchAnyInto(UserRecomContract.class);
	}

	public int cntContractBySourcePuid(String sourcePuid, String brand) {
		return mediaCtx.fetchCount(URC, URC.SOURCE_PUID.eq(sourcePuid).and(URC.BRAND.eq(brand)));
	}

	public List<UserRecomContract> getContractBySourcePuid(String sourcePuid, String brand, int start, int size) {
		return mediaCtx.selectFrom(URC).where(URC.SOURCE_PUID.eq(sourcePuid).and(URC.BRAND.eq(brand)))
				.orderBy(URC.CREATED.desc()).limit(start, size).fetchInto(UserRecomContract.class);
	}

	public int getAuditionCoinBySourcePuid(String sourcePuid, String brand) {
		Integer rs = mediaCtx.select(DSL.sum(URA.NUM)).from(URA).where(URA.SOURCE_PUID.eq(sourcePuid).and(URA.BRAND.eq(brand)))
				.fetchAnyInto(Integer.class);
		return rs == null ? 0 : rs;
	}

	public int getContractCoinBySourcePuid(String sourcePuid, String brand) {
		Integer rs = mediaCtx.select(DSL.sum(URC.NUM)).from(URC).where(URC.SOURCE_PUID.eq(sourcePuid).and(URC.BRAND.eq(brand)))
				.fetchAnyInto(Integer.class);
		return rs == null ? 0 : rs;
	}

}
