package com.jz.jar.media.repository;

import java.util.List;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.DbField;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.SysNotify;

@Lazy
@Repository
public class SysNotifyRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.SysNotify SYS = Tables.SYS_NOTIFY;

	private Condition getCondition(BrandEnum brand, String uid) {
		return SYS.UID.in(DbField.all.name(), uid).and(SYS.BRAND.eq(brand.name()));
	}

	public int countUnreadNotifies(BrandEnum brand, String uid, long timestamp) {
		return mediaCtx.fetchCount(SYS, getCondition(brand, uid).and(SYS.CREATE_TIME.gt(timestamp)));
	}

	public int countNotifies(BrandEnum brand, String uid) {
		return mediaCtx.fetchCount(SYS, getCondition(brand, uid));
	}

	public List<SysNotify> findNotifies(BrandEnum brand, String uid, int start, int size) {
		return mediaCtx.selectFrom(SYS).where(getCondition(brand, uid)).orderBy(SYS.CREATE_TIME.desc())
				.limit(start, size).fetchInto(SysNotify.class);
	}

	public void createSysNotify(String uid, String brand, String content, String sourceType, String sourceId,
			String operator) {
		mediaCtx.insertInto(SYS, SYS.UID, SYS.BRAND, SYS.CONTENT, SYS.SOURCE_TYPE, SYS.SOURCE_ID, SYS.CREATE_TIME,
				SYS.OPERATER).values(uid, brand, content, sourceType, sourceId, System.currentTimeMillis(), operator)
				.execute();
	}
}
