package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.UserCpReservationRepository;

@Lazy
@Service
public class UserCpReservationService {

	@Autowired
	private UserCpReservationRepository userCpReservationRepository;

	public void createReservation(String uid, String pid) {
		userCpReservationRepository.createReservation(uid, pid);
	}

	public void delReservation(String uid, String pid) {
		userCpReservationRepository.delReservation(uid, pid);
	}

	public boolean isReserved(String uid, String pid) {
		return userCpReservationRepository.isReserved(uid, pid);
	}

	public List<String> filterUserReservation(String uid, Collection<String> pids) {
		return userCpReservationRepository.filterUserReservation(uid, pids);
	}

	public List<String> listUidsByPid(String pid) {
		return userCpReservationRepository.listUidsByPid(pid);
	}
}
