package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.PlaylistType;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TomatoPlaylistTheme;

@Lazy
@Repository
public class TomatoPlaylistThemeRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TomatoPlaylistTheme PT = Tables.TOMATO_PLAYLIST_THEME;

	public List<TomatoPlaylistTheme> findPlaylistForTheme(Collection<String> themeIds) {
		return mediaCtx.select(PT.PID, PT.TID).from(PT).where(PT.TID.in(themeIds)).orderBy(PT.SEQ.asc())
				.fetchInto(TomatoPlaylistTheme.class);
	}

	public List<String> findPlaylistForTheme(String themeId, PlaylistType type) {
		Condition condition = PT.TID.eq(themeId);
		if (null != type)
			condition = condition.and(PT.TYPE.eq(type.name()));
		return mediaCtx.select(PT.PID).from(PT).where(condition).orderBy(PT.SEQ.asc()).fetchInto(String.class);
	}
}
