package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.RecomStudent;

@Repository
public class RecomStudentRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.RecomStudent RS = Tables.RECOM_STUDENT;

	public List<RecomStudent> getRecomStudents(int size) {
		return mediaCtx.selectFrom(RS).where(RS.STATUS.eq(1)).orderBy(RS.WEIGHT.desc(), RS.CREATE_TIME.desc())
				.limit(size).fetchInto(RecomStudent.class);
	}

}
