package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.CoinProductSetting;

@Lazy
@Repository
public class CoinProductSettingRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.CoinProductSetting CPS = Tables.COIN_PRODUCT_SETTING;

	public List<CoinProductSetting> listCoinProducts(String brand) {
		return mediaCtx.select(CPS.PID, CPS.NAME, CPS.MONEY, CPS.COIN).from(CPS).where(CPS.BRAND.eq(brand))
				.orderBy(CPS.SEQ.asc()).fetchInto(CoinProductSetting.class);
	}

	public CoinProductSetting getCoinProduct(String brand, String pid) {
		return mediaCtx.selectFrom(CPS).where(CPS.BRAND.eq(brand).and(CPS.PID.eq(pid)))
				.fetchAnyInto(CoinProductSetting.class);
	}

}
