package com.jz.jar.media.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.AppConfig;

@Lazy
@Repository
public class AppConfigRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.AppConfig AC = Tables.APP_CONFIG;

	public AppConfig getConfigInfo(String app, String platform) {
		return mediaCtx.selectFrom(AC).where(AC.APP.eq(app).and(AC.PLATFORM.eq(platform))).fetchAnyInto(AppConfig.class);
	}

}
