/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.WechatSubUser;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class WechatSubUserRepository
extends MediaBaseRepository {
    private static final WechatSubUser WU = Tables.WECHAT_SUB_USER;

    public com.jz.jooq.media.tables.pojos.WechatSubUser getWechatSubUser(String appid, String uid) {
        return (com.jz.jooq.media.tables.pojos.WechatSubUser)this.mediaCtx.selectFrom((Table)WU).where(new Condition[]{WechatSubUserRepository.WU.APPID.eq((Object)appid).and(WechatSubUserRepository.WU.UID.eq((Object)uid))}).fetchAnyInto(com.jz.jooq.media.tables.pojos.WechatSubUser.class);
    }

    public void addWechatSubUser(String appid, String uid, String phone, String code, String openid) {
        long timeMillis = System.currentTimeMillis();
        this.mediaCtx.insertInto((Table)WU, (Field)WechatSubUserRepository.WU.APPID, (Field)WechatSubUserRepository.WU.UID, (Field)WechatSubUserRepository.WU.PHONE, (Field)WechatSubUserRepository.WU.CODE, (Field)WechatSubUserRepository.WU.OPENID, (Field)WechatSubUserRepository.WU.CREATE_TIME, (Field)WechatSubUserRepository.WU.LAST_UPDATE).values((Object)appid, (Object)uid, (Object)phone, (Object)code, (Object)openid, (Object)timeMillis, (Object)timeMillis).onDuplicateKeyIgnore().execute();
    }

    public boolean isBindWechat(String appid, String uid) {
        return this.mediaCtx.fetchExists((Table)WU, WechatSubUserRepository.WU.APPID.eq((Object)appid).and(WechatSubUserRepository.WU.UID.eq((Object)uid)));
    }

    public void unbindWechat(String appid, String uid) {
        this.mediaCtx.deleteFrom((Table)WU).where(new Condition[]{WechatSubUserRepository.WU.APPID.eq((Object)appid).and(WechatSubUserRepository.WU.UID.eq((Object)uid))}).execute();
    }

    public boolean isExistOpenid(String appid, String openid) {
        return this.mediaCtx.fetchExists((Table)WU, WechatSubUserRepository.WU.APPID.eq((Object)appid).and(WechatSubUserRepository.WU.OPENID.eq((Object)openid)));
    }

    public String getPuidByOpenId(String appid, String openid) {
        return (String)this.mediaCtx.select((SelectField)WechatSubUserRepository.WU.UID).from((TableLike)WU).where(new Condition[]{WechatSubUserRepository.WU.APPID.eq((Object)appid).and(WechatSubUserRepository.WU.OPENID.eq((Object)openid))}).fetchAnyInto(String.class);
    }
}

