package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.UserCollectRepository;
import com.jz.jooq.media.tables.pojos.UserCollect;

@Lazy
@Service
public class UserCollectService {

	@Autowired
	private UserCollectRepository userCollectRepository;

	public void addCollect(String uid, String pid, BrandEnum brand) {
		userCollectRepository.addCollect(uid, pid, brand);
	}

	public List<UserCollect> getCollect(String uid, BrandEnum brand) {
		return userCollectRepository.getCollect(uid, brand);
	}

	public int countCollect(String uid, BrandEnum brand) {
		return userCollectRepository.countCollect(uid, brand);
	}

	public List<UserCollect> getCollect(String uid, BrandEnum brand, int start, int size) {
		return userCollectRepository.getCollect(uid, brand, start, size);
	}

	public boolean isCollect(String uid, String pid, BrandEnum brand) {
		return userCollectRepository.isCollect(uid, pid, brand);
	}

	public void deleteCollect(String uid, String pid, BrandEnum brand) {
		userCollectRepository.deleteCollect(uid, pid, brand);
	}

	public List<String> getExistCollect(String uid, Collection<String> pids, BrandEnum brand) {
		List<String> existCollect = userCollectRepository.getExistCollect(uid, pids, brand);
		return null == existCollect ? Lists.newArrayList() : existCollect;
	}

	public int countCollectForPlaylist(String pid) {
		return userCollectRepository.countCollectForPlaylist(pid);
	}

	public Map<String, Integer> countCollectForPlaylist(Collection<String> pids) {
		return userCollectRepository.countCollectForPlaylist(pids);
	}
}
