/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.AiMaterial;
import com.jz.jooq.media.tables.AiPackCamp;
import com.jz.jooq.media.tables.AiPackSerie;
import com.jz.jooq.media.tables.pojos.AiLesson;
import com.jz.jooq.media.tables.pojos.AiLessonSection;
import com.jz.jooq.media.tables.pojos.AiLessonSectionMaterial;
import com.jz.jooq.media.tables.pojos.AiPackCampSeq;
import com.jz.jooq.media.tables.pojos.UserAiPack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;

@Repository
public class AiRepository
extends MediaBaseRepository {
    private static final com.jz.jooq.media.tables.AiLesson AL = Tables.AI_LESSON;
    private static final com.jz.jooq.media.tables.AiLessonSection ALS = Tables.AI_LESSON_SECTION;
    private static final com.jz.jooq.media.tables.AiLessonSectionMaterial ALSM = Tables.AI_LESSON_SECTION_MATERIAL;
    private static final AiMaterial AM = Tables.AI_MATERIAL;
    private static final AiPackSerie APS = Tables.AI_PACK_SERIE;
    private static final AiPackCamp APC = Tables.AI_PACK_CAMP;
    private static final com.jz.jooq.media.tables.AiPackCampSeq APCS = Tables.AI_PACK_CAMP_SEQ;

    public AiLesson getLesson(String aid) {
        return (AiLesson)this.mediaCtx.selectFrom((Table)AL).where(new Condition[]{AiRepository.AL.AID.eq((Object)aid)}).fetchAnyInto(AiLesson.class);
    }

    public List<AiLesson> mutiGetOnlineLesson(Collection<String> aids) {
        return this.mediaCtx.selectFrom((Table)AL).where(new Condition[]{AiRepository.AL.AID.in(aids).and(AiRepository.AL.STATUS.eq((Object)1))}).fetchInto(AiLesson.class);
    }

    public List<AiLessonSection> getAiSections(String aid) {
        return this.mediaCtx.selectFrom((Table)ALS).where(new Condition[]{AiRepository.ALS.AID.eq((Object)aid)}).orderBy(AiRepository.ALS.SEQ.asc()).fetchInto(AiLessonSection.class);
    }

    public List<String> getAiSectionIds(String aid) {
        return this.mediaCtx.select((SelectField)AiRepository.ALS.SECTION_ID).from((TableLike)ALS).where(new Condition[]{AiRepository.ALS.AID.eq((Object)aid)}).orderBy(AiRepository.ALS.SEQ.asc()).fetchInto(String.class);
    }

    public List<AiLessonSectionMaterial> getAiMaterials(String aid) {
        return this.mediaCtx.selectFrom((Table)ALSM).where(new Condition[]{AiRepository.ALSM.AID.eq((Object)aid)}).orderBy(AiRepository.ALSM.SEQ.asc()).fetchInto(AiLessonSectionMaterial.class);
    }

    public List<String> getAiMaterialIdsInSection(String aid, String sectionId) {
        return this.mediaCtx.select((SelectField)AiRepository.ALSM.MATERIAL_ID).from((TableLike)ALSM).where(new Condition[]{AiRepository.ALSM.AID.eq((Object)aid).and(AiRepository.ALSM.SECTION_ID.eq((Object)sectionId))}).orderBy(AiRepository.ALSM.SEQ.asc()).fetchInto(String.class);
    }

    public List<com.jz.jooq.media.tables.pojos.AiMaterial> mutiGetOnlineMaterials(Collection<String> ids) {
        return this.mediaCtx.selectFrom((Table)AM).where(new Condition[]{AiRepository.AM.ID.in(ids).and(AiRepository.AM.STATUS.eq((Object)1))}).fetchInto(com.jz.jooq.media.tables.pojos.AiMaterial.class);
    }

    public List<com.jz.jooq.media.tables.pojos.AiPackSerie> getSeries(String pid) {
        return this.mediaCtx.selectFrom((Table)APS).where(new Condition[]{AiRepository.APS.PID.eq((Object)pid)}).orderBy(AiRepository.APS.SEQ.asc()).fetchInto(com.jz.jooq.media.tables.pojos.AiPackSerie.class);
    }

    public List<com.jz.jooq.media.tables.pojos.AiPackCamp> getJoinAbleCampsTimeName(String pid) {
        return this.mediaCtx.selectFrom((Table)APC).where(new Condition[]{AiRepository.APC.PID.eq((Object)pid).and(AiRepository.APC.SIGN_END_TIME.ge((Object)System.currentTimeMillis()))}).orderBy(AiRepository.APC.OPEN_TIME.asc()).fetchInto(com.jz.jooq.media.tables.pojos.AiPackCamp.class);
    }

    public Long getRecentJoinAbleCamp(String pid) {
        return (Long)this.mediaCtx.select((SelectField)AiRepository.APC.OPEN_TIME).from((TableLike)APC).where(new Condition[]{AiRepository.APC.PID.eq((Object)pid).and(AiRepository.APC.SIGN_END_TIME.ge((Object)System.currentTimeMillis()))}).orderBy(AiRepository.APC.OPEN_TIME.asc()).limit(1).fetchAnyInto(Long.class);
    }

    public com.jz.jooq.media.tables.pojos.AiPackCamp getCamp(String pid, long openTime) {
        return (com.jz.jooq.media.tables.pojos.AiPackCamp)this.mediaCtx.selectFrom((Table)APC).where(new Condition[]{AiRepository.APC.PID.eq((Object)pid).and(AiRepository.APC.OPEN_TIME.eq((Object)openTime))}).fetchAnyInto(com.jz.jooq.media.tables.pojos.AiPackCamp.class);
    }

    public Map<Integer, Long> getCampLessonTimeMap(String pid, long openTime) {
        return this.mediaCtx.select((SelectField)AiRepository.APCS.SEQ, (SelectField)AiRepository.APCS.LESSON_TIME).from((TableLike)APCS).where(new Condition[]{AiRepository.APCS.PID.eq((Object)pid).and(AiRepository.APCS.OPEN_TIME.eq((Object)openTime))}).fetchMap((Field)AiRepository.APCS.SEQ, (Field)AiRepository.APCS.LESSON_TIME);
    }

    public Long getLessonTime(String pid, Long openTime, int seq) {
        return (Long)this.mediaCtx.select((SelectField)AiRepository.APCS.LESSON_TIME).from((TableLike)APCS).where(new Condition[]{AiRepository.APCS.PID.eq((Object)pid).and(AiRepository.APCS.OPEN_TIME.eq((Object)openTime)).and(AiRepository.APCS.SEQ.eq((Object)seq))}).fetchAnyInto(Long.class);
    }

    public List<AiPackCampSeq> mutiGetCampLessonTimes(List<UserAiPack> uaps, Long startTime, Long endTime) {
        if (ArrayMapTools.isEmpty(uaps)) {
            return null;
        }
        ArrayList conditions = Lists.newArrayList();
        for (UserAiPack uap : uaps) {
            conditions.add(AiRepository.APCS.PID.eq((Object)uap.getPid()).and(AiRepository.APCS.OPEN_TIME.eq((Object)uap.getOpenTime())));
        }
        Condition c = DSL.or((Collection)conditions);
        if (startTime != null && endTime != null) {
            c = c.and(AiRepository.APCS.LESSON_TIME.between((Object)startTime, (Object)endTime));
        }
        return this.mediaCtx.selectFrom((Table)APCS).where(new Condition[]{c}).fetchInto(AiPackCampSeq.class);
    }

    public com.jz.jooq.media.tables.pojos.AiPackSerie getSerie(String pid, String serieId) {
        return (com.jz.jooq.media.tables.pojos.AiPackSerie)this.mediaCtx.selectFrom((Table)APS).where(new Condition[]{AiRepository.APS.PID.eq((Object)pid).and(AiRepository.APS.SERIE_ID.eq((Object)serieId))}).fetchAnyInto(com.jz.jooq.media.tables.pojos.AiPackSerie.class);
    }

    public List<String> getAiLessonMaterialIds(String aid, Collection<String> materialIds) {
        return this.mediaCtx.select((SelectField)AiRepository.ALSM.MATERIAL_ID).from((TableLike)ALSM).where(new Condition[]{AiRepository.ALSM.AID.eq((Object)aid).and(AiRepository.ALSM.MATERIAL_ID.in(materialIds))}).orderBy(AiRepository.ALSM.SEQ.asc()).fetchInto(String.class);
    }

    public List<String> filterMaterialIdsByType(Collection<String> materialIds, String type) {
        return this.mediaCtx.select((SelectField)AiRepository.AM.ID).from((TableLike)AM).where(new Condition[]{AiRepository.AM.ID.in(materialIds).and(AiRepository.AM.TYPE.eq((Object)type))}).fetchInto(String.class);
    }

    public String getMaterialTypeById(String id) {
        return (String)this.mediaCtx.select((SelectField)AiRepository.AM.TYPE).from((TableLike)AM).where(new Condition[]{AiRepository.AM.ID.eq((Object)id)}).fetchAnyInto(String.class);
    }
}

