package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.PlaylistType;
import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class TomatoContentAttributesRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TomatoContentAttributes CA = Tables.TOMATO_CONTENT_ATTRIBUTES;

	public List<String> getAttributes(String id, PlaylistType type) {
		return mediaCtx.select(CA.ATTR_ID).from(CA).where(CA.SOURCE_ID.eq(id).and(CA.TYPE.eq(type.name())))
				.fetchInto(String.class);
	}

	public List<String> findSidsForAttributes(Collection<String> attrIds, PlaylistType type, int start, int size) {
		return mediaCtx.selectDistinct(CA.SOURCE_ID).from(CA).where(CA.ATTR_ID.in(attrIds).and(CA.TYPE.eq(type.name())))
				.orderBy(CA.SOURCE_ID.desc()).limit(start, size).fetchInto(String.class);
	}

}
