package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TestsAttributes;
import com.jz.jooq.media.tables.pojos.TomatoDirection;

@Lazy
@Repository
public class TestsAttributesRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TestsAttributes TA = Tables.TESTS_ATTRIBUTES;
	private static final com.jz.jooq.media.tables.TomatoDirection TD = Tables.TOMATO_DIRECTION;

	public List<TestsAttributes> getAttributesForDirections(Collection<String> directions) {
		return mediaCtx.selectFrom(TA).where(TA.DIRECTION.in(directions)).fetchInto(TestsAttributes.class);
	}

	public String getDirectionForAttribute(String attributeId) {
		return mediaCtx.select(TA.DIRECTION).from(TA).where(TA.ATTR_ID.eq(attributeId)).fetchAnyInto(String.class);
	}

	public TomatoDirection getDirectionInfo(String direction) {
		return mediaCtx.selectFrom(TD).where(TD.DIRECTION.eq(direction)).fetchAnyInto(TomatoDirection.class);
	}
}
