/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.service;

import com.google.common.collect.Lists;
import com.jz.jar.media.repository.WorksLikeRepository;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class WorksLikeService {
    @Autowired
    private WorksLikeRepository worksLikeRepository;

    public int countForWorkId(String id) {
        return this.worksLikeRepository.countForWorkId(id);
    }

    public int countForWorkId(Collection<String> ids) {
        return this.worksLikeRepository.countForWorkId(ids);
    }

    public boolean existForIdAndUid(String id, String puid) {
        return this.worksLikeRepository.existForIdAndUid(id, puid);
    }

    public Map<String, Integer> getLikeCount(Collection<String> workIds) {
        return this.worksLikeRepository.getLikeCount(workIds);
    }

    public List<String> screenLike(Collection<String> workIds, String puid) {
        List<String> likes = this.worksLikeRepository.screenLike(workIds, puid);
        return null == likes ? Lists.newArrayList() : likes;
    }

    public void addWorksLike(String workId, String puid) {
        this.worksLikeRepository.addWorkLike(workId, puid);
    }

    public void deleteWorkLike(String workId) {
        this.worksLikeRepository.deleteWorkLike(workId);
    }

    public void deleteWorkLike(String workId, String puid) {
        this.worksLikeRepository.deleteWorkLike(workId, puid);
    }

    public int countMyLike(String puid) {
        return this.worksLikeRepository.countMyLike(puid);
    }

    public List<String> getMyLike(String puid, int start, int size) {
        return this.worksLikeRepository.getMyLike(puid, start, size);
    }
}

