package com.jz.jar.media.service;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.WorksTreasureRepository;
import com.jz.jooq.media.tables.pojos.WorksTreasure;
import com.jz.jooq.media.tables.records.WorksTreasureRecord;

@Lazy
@Service
public class WorksTreasureService {

	@Autowired
	private WorksTreasureRepository worksTreasureRepository;

	public void createTreasure(WorksTreasureRecord record) {
		worksTreasureRepository.createTreasure(record);
	}

	public WorksTreasure getTreasureById(String id) {
		return worksTreasureRepository.getTreasureById(id);
	}

	public WorksTreasure getPayedTreasureByWorkId(String workId) {
		return worksTreasureRepository.getPayedTreasureByWorkId(workId);
	}

	public List<WorksTreasure> mutiGetPayedTreasureByWorkIds(Collection<String> workIds) {
		return worksTreasureRepository.mutiGetPayedTreasureByWorkIds(workIds);
	}

	public List<String> filterPayedWorkIds(Collection<String> workIds) {
		return worksTreasureRepository.filterPayedWorkIds(workIds);
	}

	public List<WorksTreasure> getRecomTreasures(int size) {
		return worksTreasureRepository.getRecomTreasures(size);
	}

	public void finishPay(String orderId, BigDecimal payMoney, String paymentMode, String onlinePayTradeId) {
		worksTreasureRepository.finishPay(orderId, payMoney, paymentMode, onlinePayTradeId);
	}
}
