package com.jz.jar.media.repository;

import java.math.BigDecimal;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserCourseOrder;
import com.jz.jooq.media.tables.records.UserCourseOrderRecord;

@Lazy
@Repository
public class UserCourseOrderRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserCourseOrder UCO = Tables.USER_COURSE_ORDER;

	public boolean checkPayed(String uid, String brand, String pid) {
		return mediaCtx.fetchExists(
				UCO,
				UCO.UID.eq(uid).and(UCO.BRAND.eq(brand)).and(UCO.PID.eq(pid)).and(UCO.STATUS.eq(1))
						.and(UCO.END_TIME.ge(System.currentTimeMillis())));
	}

	public UserCourseOrder getPayedOrder(String uid, String brand, String pid) {
		return mediaCtx.selectFrom(UCO)
				.where(UCO.UID.eq(uid).and(UCO.BRAND.eq(brand)).and(UCO.PID.eq(pid)).and(UCO.STATUS.eq(1)))
				.orderBy(UCO.END_TIME.desc()).limit(1).fetchAnyInto(UserCourseOrder.class);
	}

	public void createOrder(UserCourseOrderRecord record) {
		mediaCtx.batchInsert(record).execute();
	}

	public UserCourseOrder getOrder(String orderId) {
		return mediaCtx.selectFrom(UCO).where(UCO.ORDER_ID.eq(orderId)).fetchAnyInto(UserCourseOrder.class);
	}

	public void finishPay(String orderId, BigDecimal payMoney, String paymentMode, String onlineTradeId) {
		mediaCtx.update(UCO).set(UCO.PAY_MONEY, payMoney).set(UCO.PAYMENT_MODE, paymentMode)
				.set(UCO.ONLINE_PAY_TRADE_ID, onlineTradeId).set(UCO.STATUS, 1)
				.set(UCO.PAY_TIME, System.currentTimeMillis()).where(UCO.ORDER_ID.eq(orderId)).execute();
	}

}
