/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.service;

import com.jz.jar.media.cache.MediaVideoCache;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.MediaVideoRepository;
import com.jz.jooq.media.tables.pojos.MediaVideo;
import com.jz.jooq.media.tables.records.MediaVideoRecord;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class MediaVideoService {
    @Autowired
    private MediaVideoRepository mediaVideoRepository;
    @Autowired
    private MediaVideoCache mediaVideoCache;

    public MediaVideo getVideo(String wid, BrandEnum brand) {
        MediaVideo video = this.mediaVideoCache.getMediaVideo(wid, brand);
        if (null != video) {
            return video;
        }
        video = this.mediaVideoRepository.getVideo(wid, brand);
        if (null == video) {
            return null;
        }
        this.mediaVideoCache.setMediaVideo(video, brand);
        return video;
    }

    public List<MediaVideo> findVideos(Collection<String> wids) {
        return this.mediaVideoRepository.findVideos(wids);
    }

    public void saveOrUpdateVideo(MediaVideoRecord mediaVideoRecord) {
        this.mediaVideoRepository.saveOrUpdateVideo(mediaVideoRecord);
    }

    public boolean isExist(String wid, BrandEnum brand) {
        return this.mediaVideoRepository.isExist(wid, brand);
    }

    public boolean isOnlineExist(String wid, BrandEnum brand) {
        return this.mediaVideoRepository.isOnlineExist(wid, brand);
    }

    public void addWatchCnt(String wid, BrandEnum brand, int cnt) {
        this.mediaVideoRepository.addWatchCnt(wid, brand, cnt);
    }

    public List<String> filterOnlineVideo(Collection<String> wids, BrandEnum brand) {
        return this.mediaVideoRepository.filterOnlineVideo(wids, brand);
    }
}

