package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.WorksAuthorRepository;
import com.jz.jooq.media.tables.pojos.WorksAuthor;

@Lazy
@Service
public class WorksAuthorService {

	@Autowired
	private WorksAuthorRepository worksAuthorRepository;

	public List<String> getWorksAuthors(BrandEnum brand, String workId) {
		return worksAuthorRepository.getWorksAuthors(brand, workId);
	}

	public List<String> getWorksAuthorParents(BrandEnum brand, String workId) {
		return worksAuthorRepository.getWorksAuthorParents(brand, workId);
	}

	public boolean isWorksAuthor(BrandEnum brand, String workId, String suid) {
		return worksAuthorRepository.isWorksAuthor(brand, workId, suid);
	}

	public boolean isWorksAuthorParent(BrandEnum brand, String workId, String puid) {
		return worksAuthorRepository.isWorksAuthorParent(brand, workId, puid);
	}

	public String getWorksAuthor(BrandEnum brand, String workId) {
		return worksAuthorRepository.getWorksAuthor(brand, workId);
	}

	public String getWorksAuthorParent(BrandEnum brand, String workId) {
		return worksAuthorRepository.getWorksAuthorParent(brand, workId);
	}

	public List<WorksAuthor> findWorkAuthor(BrandEnum brand, Collection<String> workIds) {
		return worksAuthorRepository.findWorkAuthor(brand, workIds);
	}

	public int countStudentWorks(BrandEnum brand, Collection<String> puids, String suid, Integer isOpen) {
		return worksAuthorRepository.countStudentWorks(brand, puids, suid, isOpen);
	}

	public List<String> findStudentWorksId(BrandEnum brand, Collection<String> puids, String suid, Integer isOpen,
			int start, int size) {
		return worksAuthorRepository.findStudentWorksId(brand, puids, suid, isOpen, start, size);
	}

	public List<String> findAllStudentWorksId(BrandEnum brand, Collection<String> puids, String suid, Integer isOpen) {
		return worksAuthorRepository.findAllStudentWorksId(brand, puids, suid, isOpen);
	}

	public int countStudentWorksWithRel(BrandEnum brand, Collection<String> suids, String suid, Integer isOpen) {
		return worksAuthorRepository.countStudentWorksWithRel(brand, suids, suid, isOpen);
	}

	public List<String> findStudentWorksIdWithRel(BrandEnum brand, Collection<String> suids, String suid,
			Integer isOpen, int start, int size) {
		return worksAuthorRepository.findStudentWorksIdWithRel(brand, suids, suid, isOpen, start, size);
	}

	public List<String> findAllStudentWorksIdWithRel(BrandEnum brand, Collection<String> suids, String suid,
			Integer isOpen) {
		return worksAuthorRepository.findAllStudentWorksIdWithRel(brand, suids, suid, isOpen);
	}

	public List<WorksAuthor> findExistWorksInfo(Map<String, Collection<String>> school2LessonIds, String suid) {
		return worksAuthorRepository.findExistWorksInfo(school2LessonIds, suid);
	}

	public String getWorkIdByLesson(String schoolId, String lessonId, String suid) {
		return worksAuthorRepository.getWorkIdByLesson(schoolId, lessonId, suid);
	}

	public void updateOpenInfo(String workId, int isOpen) {
		worksAuthorRepository.updateOpenInfo(workId, isOpen);
	}

	public void createWorkAuthor(String brandId, String id, String schoolId, String lessonId, String puid, String suid,
			int isCollective) {
		worksAuthorRepository.createWorkAuthor(brandId, id, schoolId, lessonId, puid, suid, isCollective);
	}

	public Map<String, Integer> getStudentWorksCnt(BrandEnum brand, List<String> suids) {
		List<Map<String, Object>> list = worksAuthorRepository.getStudentWorksCnt(brand, suids);
		Map<String, Integer> map = Maps.newHashMap();
		for (Map<String, Object> m : list) {
			map.put(MapUtils.getString(m, "suid"), MapUtils.getIntValue(m, "worksCnt"));
		}
		return map;
	}

	public List<WorksAuthor> filterWorksAuthor(String suid, Map<String, Collection<String>> school2Lessons) {
		return worksAuthorRepository.filterWorksAuthor(suid, school2Lessons);
	}

}
