package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.Map;

import org.jooq.Record2;
import org.jooq.Result;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;
import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class UserSignRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserSign US = Tables.USER_SIGN;

	public void save(String uid, String suid, String date) {
		mediaCtx.insertInto(US, US.UID, US.SUID, US.SIGN_DATE, US.CREATE_TIME)
				.values(uid, suid, date, System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
	}

	public int countDays(String uid, String suid) {
		return mediaCtx.fetchCount(US, US.UID.eq(uid).and(US.SUID.eq(suid)));
	}

	public Map<String, Integer> getCountDays(String uid, Collection<String> suidArray) {
		Result<Record2<String, Integer>> result = mediaCtx.select(US.SUID, DSL.count(US.SUID)).from(US)
				.where(US.UID.eq(uid).and(US.SUID.in(suidArray))).groupBy(US.SUID).fetch();
		if (null == result || result.isEmpty())
			return Maps.newHashMap();
		Map<String, Integer> has = Maps.newHashMap();
		result.forEach(it -> has.put(it.value1(), it.value2()));
		return has;
	}

}
