/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.Reservation;
import com.jz.jooq.media.tables.records.ReservationRecord;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class ReservationRepository
extends MediaBaseRepository {
    private static final Reservation RT = Tables.RESERVATION;

    public void saveRecord(ReservationRecord record) {
        this.mediaCtx.insertInto((Table)RT).set((Record)record).execute();
    }

    public boolean existValidReservation(String uid, String schoolId) {
        return this.mediaCtx.fetchExists((Table)RT, ReservationRepository.RT.UID.eq((Object)uid).and(ReservationRepository.RT.SCHOOL_ID.eq((Object)schoolId)).and(ReservationRepository.RT.STATUS.eq((Object)1)));
    }

    public boolean existReservation(String uid) {
        return this.mediaCtx.fetchExists((Table)RT, ReservationRepository.RT.UID.eq((Object)uid));
    }

    public int countValidReservation(BrandEnum brand, String uid) {
        return this.mediaCtx.fetchCount((Table)RT, ReservationRepository.RT.UID.eq((Object)uid).and(ReservationRepository.RT.STATUS.eq((Object)1)).and(ReservationRepository.RT.BRAND.eq((Object)brand.name())));
    }

    public int countValidReservation(String brandId, String uid) {
        return this.mediaCtx.fetchCount((Table)RT, ReservationRepository.RT.UID.eq((Object)uid).and(ReservationRepository.RT.STATUS.eq((Object)1)).and(ReservationRepository.RT.BRAND.eq((Object)brandId)));
    }

    public List<String> getReservationSchools(BrandEnum brand, String uid) {
        return this.mediaCtx.select((SelectField)ReservationRepository.RT.SCHOOL_ID).from((TableLike)RT).where(new Condition[]{ReservationRepository.RT.UID.eq((Object)uid).and(ReservationRepository.RT.BRAND.eq((Object)brand.name()))}).orderBy(ReservationRepository.RT.CREATE_TIME.asc()).fetchInto(String.class);
    }
}

