/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.BaseConditionRepository;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.WorksAuthor;
import com.jz.jooq.media.tables.records.WorksAuthorRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class WorksAuthorRepository
extends MediaBaseRepository
implements BaseConditionRepository<WorksAuthorRecord> {
    private static final com.jz.jooq.media.tables.WorksAuthor WA = Tables.WORKS_AUTHOR;

    private Condition getWorkIdCondition(BrandEnum brand, String workId) {
        return WorksAuthorRepository.WA.WORK_ID.eq((Object)workId).and(WorksAuthorRepository.WA.BRAND.eq((Object)brand.name()));
    }

    public List<String> getWorksAuthors(BrandEnum brand, String workId) {
        return this.mediaCtx.select((SelectField)WorksAuthorRepository.WA.SUID).from((TableLike)WA).where(new Condition[]{this.getWorkIdCondition(brand, workId)}).fetchInto(String.class);
    }

    public List<String> getWorksAuthorParents(BrandEnum brand, String workId) {
        return this.mediaCtx.select((SelectField)WorksAuthorRepository.WA.PUID).from((TableLike)WA).where(new Condition[]{this.getWorkIdCondition(brand, workId)}).fetchInto(String.class);
    }

    public boolean isWorksAuthor(BrandEnum brand, String workId, String suid) {
        return this.mediaCtx.fetchExists((Table)WA, this.getWorkIdCondition(brand, workId).and(WorksAuthorRepository.WA.SUID.eq((Object)suid)));
    }

    public boolean isWorksAuthorParent(BrandEnum brand, String workId, String puid) {
        return this.mediaCtx.fetchExists((Table)WA, this.getWorkIdCondition(brand, workId).and(WorksAuthorRepository.WA.PUID.eq((Object)puid)));
    }

    public String getWorksAuthor(BrandEnum brand, String workId) {
        return (String)this.mediaCtx.select((SelectField)WorksAuthorRepository.WA.SUID).from((TableLike)WA).where(new Condition[]{this.getWorkIdCondition(brand, workId)}).fetchAnyInto(String.class);
    }

    public String getWorksAuthorParent(BrandEnum brand, String workId) {
        return (String)this.mediaCtx.select((SelectField)WorksAuthorRepository.WA.PUID).from((TableLike)WA).where(new Condition[]{this.getWorkIdCondition(brand, workId)}).fetchAnyInto(String.class);
    }

    public List<WorksAuthor> findWorkAuthor(BrandEnum brand, Collection<String> workIds) {
        return this.mediaCtx.selectFrom((Table)WA).where(new Condition[]{WorksAuthorRepository.WA.WORK_ID.in(workIds).and(WorksAuthorRepository.WA.BRAND.eq((Object)brand.name()))}).fetchInto(WorksAuthor.class);
    }

    private Condition getStudentCondition(BrandEnum brand, Collection<String> puids, String suid, Integer isOpen) {
        if (ArrayMapTools.isEmpty(puids)) {
            throw new RuntimeException("puids empty");
        }
        Condition condition = WorksAuthorRepository.WA.BRAND.eq((Object)brand.name()).and(WorksAuthorRepository.WA.PUID.in(puids));
        if (StringTools.isNotEmptyAndBlank((String)suid)) {
            condition = condition.and(WorksAuthorRepository.WA.SUID.eq((Object)suid));
        }
        if (null != isOpen) {
            condition = condition.and(WorksAuthorRepository.WA.IS_OPEN.eq((Object)isOpen));
        }
        return condition;
    }

    public int countStudentWorks(BrandEnum brand, Collection<String> puids, String suid, Integer isOpen) {
        return this.mediaCtx.fetchCount((Table)WA, this.getStudentCondition(brand, puids, suid, isOpen));
    }

    public List<String> findStudentWorksId(BrandEnum brand, Collection<String> puids, String suid, Integer isOpen, int start, int size) {
        return this.mediaCtx.select((SelectField)WorksAuthorRepository.WA.WORK_ID).from((TableLike)WA).where(new Condition[]{this.getStudentCondition(brand, puids, suid, isOpen)}).orderBy(WorksAuthorRepository.WA.ID.desc()).limit(start, size).fetchInto(String.class);
    }

    public List<String> findAllStudentWorksId(BrandEnum brand, Collection<String> puids, String suid, Integer isOpen) {
        return this.mediaCtx.select((SelectField)WorksAuthorRepository.WA.WORK_ID).from((TableLike)WA).where(new Condition[]{this.getStudentCondition(brand, puids, suid, isOpen)}).fetchInto(String.class);
    }

    public List<WorksAuthor> findExistWorksInfo(Map<String, Collection<String>> school2LessonIds, String suid) {
        Condition condition = this.getOrWhereCondition(WorksAuthorRepository.WA.SCHOOL_ID, WorksAuthorRepository.WA.LESSON_ID, school2LessonIds);
        return this.mediaCtx.select((SelectField)WorksAuthorRepository.WA.SCHOOL_ID, (SelectField)WorksAuthorRepository.WA.LESSON_ID, (SelectField)WorksAuthorRepository.WA.WORK_ID, (SelectField)WorksAuthorRepository.WA.IS_COLLECTIVE).from((TableLike)WA).where(new Condition[]{condition.and(WorksAuthorRepository.WA.SUID.eq((Object)suid))}).fetchInto(WorksAuthor.class);
    }

    public void updateOpenInfo(String workId, int isOpen) {
        this.mediaCtx.update((Table)WA).set((Field)WorksAuthorRepository.WA.IS_OPEN, (Object)isOpen).where(new Condition[]{WorksAuthorRepository.WA.WORK_ID.eq((Object)workId)}).execute();
    }

    public void createWorkAuthor(String brandId, String id, String schoolId, String lessonId, String puid, String suid, int isCollective) {
        this.mediaCtx.insertInto((Table)WA, (Field)WorksAuthorRepository.WA.BRAND, (Field)WorksAuthorRepository.WA.WORK_ID, (Field)WorksAuthorRepository.WA.SCHOOL_ID, (Field)WorksAuthorRepository.WA.LESSON_ID, (Field)WorksAuthorRepository.WA.PUID, (Field)WorksAuthorRepository.WA.SUID, (Field)WorksAuthorRepository.WA.IS_COLLECTIVE).values((Object)brandId, (Object)id, (Object)schoolId, (Object)lessonId, (Object)puid, (Object)suid, (Object)isCollective).onDuplicateKeyIgnore().execute();
    }

    public int countStudentWorksWithRel(BrandEnum brand, Collection<String> suids, String suid, Integer isOpen) {
        return this.mediaCtx.fetchCount((Table)WA, this.genWithRelCondition(brand, suids, suid, isOpen));
    }

    public List<String> findStudentWorksIdWithRel(BrandEnum brand, Collection<String> suids, String suid, Integer isOpen, int start, int size) {
        return this.mediaCtx.select((SelectField)WorksAuthorRepository.WA.WORK_ID).from((TableLike)WA).where(new Condition[]{this.genWithRelCondition(brand, suids, suid, isOpen)}).orderBy(WorksAuthorRepository.WA.ID.desc()).limit(start, size).fetchInto(String.class);
    }

    public List<String> findAllStudentWorksIdWithRel(BrandEnum brand, Collection<String> suids, String suid, Integer isOpen) {
        return this.mediaCtx.select((SelectField)WorksAuthorRepository.WA.WORK_ID).from((TableLike)WA).where(new Condition[]{this.genWithRelCondition(brand, suids, suid, isOpen)}).fetchInto(String.class);
    }

    private Condition genWithRelCondition(BrandEnum brand, Collection<String> suids, String suid, Integer isOpen) {
        if (ArrayMapTools.isEmpty(suids)) {
            throw new RuntimeException("suids empty");
        }
        Condition condition = WorksAuthorRepository.WA.BRAND.eq((Object)brand.name()).and(WorksAuthorRepository.WA.SUID.in(suids));
        if (StringTools.isNotEmptyAndBlank((String)suid)) {
            condition = condition.and(WorksAuthorRepository.WA.SUID.eq((Object)suid));
        }
        if (null != isOpen) {
            condition = condition.and(WorksAuthorRepository.WA.IS_OPEN.eq((Object)isOpen));
        }
        return condition;
    }

    public List<Map<String, Object>> getStudentWorksCnt(BrandEnum brand, List<String> suids) {
        return this.mediaCtx.select((SelectField)WorksAuthorRepository.WA.SUID.as("suid"), (SelectField)DSL.count((Field)WorksAuthorRepository.WA.WORK_ID).as("worksCnt")).from((TableLike)WA).where(new Condition[]{WorksAuthorRepository.WA.BRAND.eq((Object)brand.name()).and(WorksAuthorRepository.WA.SUID.in(suids))}).groupBy(new GroupField[]{WorksAuthorRepository.WA.SUID}).fetchMaps();
    }

    public List<WorksAuthor> filterWorksAuthor(String suid, Map<String, Collection<String>> school2Lessons) {
        ArrayList conditions = Lists.newArrayList();
        school2Lessons.forEach((schoolId, lessonIds) -> conditions.add(WorksAuthorRepository.WA.SCHOOL_ID.eq(schoolId).and(WorksAuthorRepository.WA.LESSON_ID.in(lessonIds))));
        return this.mediaCtx.selectFrom((Table)WA).where(new Condition[]{DSL.or((Collection)conditions).and(WorksAuthorRepository.WA.IS_OPEN.eq((Object)1).or(WorksAuthorRepository.WA.IS_OPEN.eq((Object)0).and(WorksAuthorRepository.WA.SUID.eq((Object)suid))))}).fetchInto(WorksAuthor.class);
    }
}

