package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TomatoHomeModel;
import com.jz.jooq.media.tables.pojos.TomatoHomeModelPic;

@Lazy
@Repository
public class TomatoHomeModelRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TomatoHomeModel THM = Tables.TOMATO_HOME_MODEL;
	private static final com.jz.jooq.media.tables.TomatoHomeModelPic THMP = Tables.TOMATO_HOME_MODEL_PIC;

	public List<TomatoHomeModel> listModels(String ver) {
		return mediaCtx.selectFrom(THM).where(THM.VER.eq(ver).and(THM.STATUS.eq(1))).orderBy(THM.WEIGHT.desc())
				.fetchInto(TomatoHomeModel.class);
	}

	public List<TomatoHomeModelPic> mutiGetItems(Collection<String> modelIds) {
		return mediaCtx.selectFrom(THMP).where(THMP.MODEL_ID.in(modelIds)).orderBy(THMP.MODEL_ID.asc(), THMP.SEQ.asc())
				.fetchInto(TomatoHomeModelPic.class);
	}

}
