package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.AiLesson;
import com.jz.jooq.media.tables.pojos.AiLessonSection;
import com.jz.jooq.media.tables.pojos.AiLessonSectionMaterial;
import com.jz.jooq.media.tables.pojos.AiMaterial;
import com.jz.jooq.media.tables.pojos.AiPackCamp;
import com.jz.jooq.media.tables.pojos.AiPackSerie;

@Repository
public class AiRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.AiLesson AL = Tables.AI_LESSON;
	private static final com.jz.jooq.media.tables.AiLessonSection ALS = Tables.AI_LESSON_SECTION;
	private static final com.jz.jooq.media.tables.AiLessonSectionMaterial ALSM = Tables.AI_LESSON_SECTION_MATERIAL;
	private static final com.jz.jooq.media.tables.AiMaterial AM = Tables.AI_MATERIAL;
	private static final com.jz.jooq.media.tables.AiPackSerie APS = Tables.AI_PACK_SERIE;
	private static final com.jz.jooq.media.tables.AiPackCamp APC = Tables.AI_PACK_CAMP;
	private static final com.jz.jooq.media.tables.AiPackCampSeq APCS = Tables.AI_PACK_CAMP_SEQ;

	public AiLesson getLesson(String aid) {
		return mediaCtx.selectFrom(AL).where(AL.AID.eq(aid)).fetchAnyInto(AiLesson.class);
	}

	public List<AiLesson> mutiGetOnlineLesson(Collection<String> aids) {
		return mediaCtx.selectFrom(AL).where(AL.AID.in(aids).and(AL.STATUS.eq(1))).fetchInto(AiLesson.class);
	}

	public List<AiLessonSection> getAiSections(String aid) {
		return mediaCtx.selectFrom(ALS).where(ALS.AID.eq(aid)).orderBy(ALS.SEQ.asc()).fetchInto(AiLessonSection.class);
	}

	public List<String> getAiSectionIds(String aid) {
		return mediaCtx.select(ALS.SECTION_ID).from(ALS).where(ALS.AID.eq(aid)).orderBy(ALS.SEQ.asc())
				.fetchInto(String.class);
	}

	public List<AiLessonSectionMaterial> getAiMaterials(String aid) {
		return mediaCtx.selectFrom(ALSM).where(ALSM.AID.eq(aid)).orderBy(ALSM.SEQ.asc())
				.fetchInto(AiLessonSectionMaterial.class);
	}

	public List<String> getAiMaterialIdsInSection(String aid, String sectionId) {
		return mediaCtx.select(ALSM.MATERIAL_ID).from(ALSM).where(ALSM.AID.eq(aid).and(ALSM.SECTION_ID.eq(sectionId)))
				.orderBy(ALSM.SEQ.asc()).fetchInto(String.class);
	}

	public AiMaterial getMaterial(String id) {
		return mediaCtx.selectFrom(AM).where(AM.ID.eq(id)).fetchAnyInto(AiMaterial.class);
	}

	public List<AiMaterial> mutiGetOnlineMaterials(Collection<String> ids) {
		return mediaCtx.selectFrom(AM).where(AM.ID.in(ids).and(AM.STATUS.eq(1))).fetchInto(AiMaterial.class);
	}

	public List<AiPackSerie> getSeries(String pid) {
		return mediaCtx.selectFrom(APS).where(APS.PID.eq(pid)).orderBy(APS.SEQ.asc()).fetchInto(AiPackSerie.class);
	}

	public List<AiPackCamp> getJoinAbleCampsTimeName(String pid) {
		return mediaCtx.selectFrom(APC).where(APC.PID.eq(pid).and(APC.SIGN_END_TIME.ge(System.currentTimeMillis())))
				.orderBy(APC.OPEN_TIME.asc()).fetchInto(AiPackCamp.class);
	}

	public Long getRecentJoinAbleCamp(String pid) {
		return mediaCtx.select(APC.OPEN_TIME).from(APC)
				.where(APC.PID.eq(pid).and(APC.SIGN_END_TIME.ge(System.currentTimeMillis())))
				.orderBy(APC.OPEN_TIME.asc()).limit(1).fetchAnyInto(Long.class);
	}

	public AiPackCamp getCamp(String pid, long openTime) {
		return mediaCtx.selectFrom(APC).where(APC.PID.eq(pid).and(APC.OPEN_TIME.eq(openTime)))
				.fetchAnyInto(AiPackCamp.class);
	}

	public Map<Integer, Long> getCampLessonTimeMap(String pid, long openTime) {
		return mediaCtx.select(APCS.SEQ, APCS.LESSON_TIME).from(APCS)
				.where(APCS.PID.eq(pid).and(APCS.OPEN_TIME.eq(openTime))).fetchMap(APCS.SEQ, APCS.LESSON_TIME);
	}

	public Long getLessonTime(String pid, Long openTime, int seq) {
		return mediaCtx.select(APCS.LESSON_TIME).from(APCS)
				.where(APCS.PID.eq(pid).and(APCS.OPEN_TIME.eq(openTime)).and(APCS.SEQ.eq(seq)))
				.fetchAnyInto(Long.class);
	}

	public AiPackSerie getSerie(String pid, String serieId) {
		return mediaCtx.selectFrom(APS).where(APS.PID.eq(pid).and(APS.SERIE_ID.eq(serieId)))
				.fetchAnyInto(AiPackSerie.class);
	}

	public List<String> filterPicAudioMaterialIds(Collection<String> materialIds) {
		return mediaCtx.select(AM.ID).from(AM).where(AM.ID.in(materialIds).and(AM.TYPE.eq("picAudio")))
				.fetchInto(String.class);
	}
}
