/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.enums.AuditStatus;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.UserModifyAudit;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Table;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserModifyAuditRepository
extends MediaBaseRepository {
    private static final UserModifyAudit UMA = Tables.USER_MODIFY_AUDIT;

    private Condition getCondition(String uid, String suid) {
        return UserModifyAuditRepository.UMA.UID.eq((Object)uid).and(UserModifyAuditRepository.UMA.SUID.eq((Object)suid)).and(UserModifyAuditRepository.UMA.STATUS.eq((Object)AuditStatus.verify.getCode()));
    }

    public void refreshUserModify(String uid, String suid, String name, String avatar) {
        String tmpSuid = StringTools.ternary((String)suid);
        Condition condition = this.getCondition(uid, tmpSuid);
        long timeMillis = System.currentTimeMillis();
        if (this.mediaCtx.fetchExists((Table)UMA, condition)) {
            this.mediaCtx.update((Table)UMA).set((Field)UserModifyAuditRepository.UMA.NAME, (Object)name).set((Field)UserModifyAuditRepository.UMA.AVATAR, (Object)avatar).set((Field)UserModifyAuditRepository.UMA.LAST_UPDATE, (Object)timeMillis).where(new Condition[]{condition}).execute();
            return;
        }
        this.mediaCtx.insertInto((Table)UMA, (Field)UserModifyAuditRepository.UMA.UID, (Field)UserModifyAuditRepository.UMA.SUID, (Field)UserModifyAuditRepository.UMA.NAME, (Field)UserModifyAuditRepository.UMA.AVATAR, (Field)UserModifyAuditRepository.UMA.STATUS, (Field)UserModifyAuditRepository.UMA.LAST_UPDATE).values((Object)uid, (Object)tmpSuid, (Object)name, (Object)avatar, (Object)AuditStatus.verify.getCode(), (Object)timeMillis).execute();
    }
}

