package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.PostConstruct;

import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.jz.jar.media.repository.UserCoinTaskRepository;
import com.jz.jooq.media.tables.pojos.UserCoinTaskDay;
import com.jz.jooq.media.tables.pojos.UserCoinTaskSetting;

/**
 * @author 连杰
 */
@Lazy
@Service
@EnableScheduling
public class UserCoinTaskService {

	private static final Logger logger = LoggerFactory.getLogger(UserCoinTaskService.class);

	@Autowired
	private UserCoinTaskRepository userCoinTaskRepository;
	@Autowired
	private UserCoinService userCoinService;

	public static Map<String, Map<String, UserCoinTaskSetting>> brand2TaskSettingMap = Maps.newHashMap();

	@PostConstruct
	@Scheduled(cron = "0 */5 * * * ?")
	public void cacheTask() {
		try {
			Map<String, Map<String, UserCoinTaskSetting>> brand2TaskSettingMapTemp = Maps.newHashMap();
			List<UserCoinTaskSetting> settings = userCoinTaskRepository.listSettings();
			for (UserCoinTaskSetting s : settings) {
				if (!brand2TaskSettingMapTemp.containsKey(s.getBrand())) {
					brand2TaskSettingMapTemp.put(s.getBrand(), Maps.newHashMap());
				}
				brand2TaskSettingMapTemp.get(s.getBrand()).put(s.getId(), s);
			}
			brand2TaskSettingMap = brand2TaskSettingMapTemp;
			logger.info("settings.size:" + settings.size() + " brand2TaskSettingMap.size:"
					+ brand2TaskSettingMap.size());
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}

	public Integer dealTask(String uid, String brand, String taskId) {
		if (!brand2TaskSettingMap.containsKey(brand)) {
			return null;
		}
		UserCoinTaskSetting task = brand2TaskSettingMap.get(brand).get(taskId);
		if (task == null || task.getNum() <= 0) {
			return null;
		}
		if (task.getType() == 1) { // 任务只做一次,以后可以扩展任务类型
			if (userCoinTaskRepository.isExistTaskRecord(uid, brand, taskId)) {
				return null;
			}
			userCoinTaskRepository.createTaskRecord(uid, brand, taskId, task.getNum());
			userCoinService.updateUserCoin(uid, brand, task.getNum(), task.getName());
			return task.getNum();
		} else if (task.getType() == 2) {
			userCoinService.updateUserCoin(uid, brand, task.getNum(), task.getName());
			return task.getNum();
		}
		return null;
	}

	public UserCoinTaskSetting getTask(String brand, String taskId) {
		if (!brand2TaskSettingMap.containsKey(brand)) {
			return null;
		}
		return brand2TaskSettingMap.get(brand).get(taskId);
	}

	public List<String> mutiGetOnceTaskRecord(String uid, String brand, Collection<String> taskIds) {
		return userCoinTaskRepository.mutiGetOnceTaskRecord(uid, brand, taskIds);
	}

	public void createTaskDay(String uid, String brand, String type, String date, Integer num, Integer taskDays) {
		userCoinTaskRepository.createTaskDay(uid, brand, type, date, num, taskDays);
	}

	public UserCoinTaskDay getTaskDay(String uid, String brand, String type, String date) {
		return userCoinTaskRepository.getTaskDay(uid, brand, type, date);
	}

	public List<UserCoinTaskDay> getRecentTaskDay(String uid, String brand, String type, String minDate) {
		return userCoinTaskRepository.getRecentTaskDay(uid, brand, type, minDate);
	}

	public List<UserCoinTaskDay> mutiGetTaskDay(String uid, String brand, List<Pair<String, String>> typeDatePairs) {
		return userCoinTaskRepository.mutiGetTaskDay(uid, brand, typeDatePairs);
	}
}
