package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TomatoCourseAudio;

@Lazy
@Repository
public class TomatoCourseAudioRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TomatoCourseAudio TCA = Tables.TOMATO_COURSE_AUDIO;

	public TomatoCourseAudio getOnlineAudio(String id, String brand) {
		return mediaCtx.selectFrom(TCA).where(TCA.ID.eq(id).and(TCA.BRAND.eq(brand)).and(TCA.STATUS.eq(1)))
				.fetchAnyInto(TomatoCourseAudio.class);
	}

	public List<TomatoCourseAudio> mutiGetOnlineAudios(Collection<String> ids, String brand) {
		return mediaCtx.selectFrom(TCA).where(TCA.ID.in(ids).and(TCA.BRAND.eq(brand)).and(TCA.STATUS.eq(1)))
				.fetchInto(TomatoCourseAudio.class);
	}

}
