package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class UserCpReservationRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserCpReservation UCR = Tables.USER_CP_RESERVATION;

	public void createReservation(String uid, String pid) {
		mediaCtx.insertInto(UCR, UCR.UID, UCR.PID, UCR.CREATE_TIME).values(uid, pid, System.currentTimeMillis())
				.onDuplicateKeyIgnore().execute();
	}

	public void delReservation(String uid, String pid) {
		mediaCtx.deleteFrom(UCR).where(UCR.UID.eq(uid).and(UCR.PID.eq(pid))).execute();
	}

	public boolean isReserved(String uid, String pid) {
		return mediaCtx.fetchExists(UCR, UCR.UID.eq(uid).and(UCR.PID.eq(pid)));
	}

	public List<String> filterUserReservation(String uid, Collection<String> pids) {
		return mediaCtx.select(UCR.PID).from(UCR).where(UCR.UID.eq(uid).and(UCR.PID.in(pids))).fetchInto(String.class);
	}

	public List<String> listUidsByPid(String pid) {
		return mediaCtx.select(UCR.UID).from(UCR).where(UCR.PID.eq(pid)).fetchInto(String.class);
	}

}
