package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.StudentDayPlayRepository;

@Lazy
@Service
public class StudentDayPlayService {

	@Autowired
	private StudentDayPlayRepository studentDayPlayRepository;

	public void saveTodayPlay(String today, String suid, String pid, int targetCnt, int playCnt, String nextWid) {
		studentDayPlayRepository.saveTodayPlay(today, suid, pid, targetCnt, playCnt, nextWid);
	}

	public List<String> getTodayCompletePlaylist(String today, String suid, Collection<String> pids) {
		return studentDayPlayRepository.getTodayCompletePlaylist(today, suid, pids);
	}

	public int countLaterDays(String firstDay, String suid) {
		return studentDayPlayRepository.countLaterDays(firstDay, suid);
	}
	
	public Map<String, Integer> getEverdayCompletedPlaylistCount(Collection<String> days, String suid) {
		return studentDayPlayRepository.getEverdayCompletedPlaylistCount(days, suid);
	}
}
