package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TeacherInfo;

@Lazy
@Repository
public class TeacherInfoRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TeacherInfo TI = Tables.TEACHER_INFO;

	public List<TeacherInfo> mutiGetSimpleTeachers(Collection<String> ids) {
		return mediaCtx.select(TI.ID, TI.NAME, TI.PIC).from(TI).where(TI.ID.in(ids)).fetchInto(TeacherInfo.class);
	}

	public TeacherInfo getTeacherInfo(String id) {
		return mediaCtx.selectFrom(TI).where(TI.ID.eq(id)).fetchAnyInto(TeacherInfo.class);
	}

}
