/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.UserCpReservation;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserCpReservationRepository
extends MediaBaseRepository {
    private static final UserCpReservation UCR = Tables.USER_CP_RESERVATION;

    public void createReservation(String uid, String pid) {
        this.mediaCtx.insertInto((Table)UCR, (Field)UserCpReservationRepository.UCR.UID, (Field)UserCpReservationRepository.UCR.PID, (Field)UserCpReservationRepository.UCR.CREATE_TIME).values((Object)uid, (Object)pid, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public void delReservation(String uid, String pid) {
        this.mediaCtx.deleteFrom((Table)UCR).where(new Condition[]{UserCpReservationRepository.UCR.UID.eq((Object)uid).and(UserCpReservationRepository.UCR.PID.eq((Object)pid))}).execute();
    }

    public boolean isReserved(String uid, String pid) {
        return this.mediaCtx.fetchExists((Table)UCR, UserCpReservationRepository.UCR.UID.eq((Object)uid).and(UserCpReservationRepository.UCR.PID.eq((Object)pid)));
    }

    public List<String> filterUserReservation(String uid, Collection<String> pids) {
        return this.mediaCtx.select((SelectField)UserCpReservationRepository.UCR.PID).from((TableLike)UCR).where(new Condition[]{UserCpReservationRepository.UCR.UID.eq((Object)uid).and(UserCpReservationRepository.UCR.PID.in(pids))}).fetchInto(String.class);
    }

    public List<String> listUidsByPid(String pid) {
        return this.mediaCtx.select((SelectField)UserCpReservationRepository.UCR.UID).from((TableLike)UCR).where(new Condition[]{UserCpReservationRepository.UCR.PID.eq((Object)pid)}).fetchInto(String.class);
    }
}

