package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.UserCollectImageTextRepository;
import com.jz.jooq.media.tables.pojos.UserCollectImageText;

@Lazy
@Service
public class UserCollectImageTextService {

	@Autowired
	private UserCollectImageTextRepository userCollectImageTextRepository;

	public void addCollect(String uid, String iid, String pid) {
		userCollectImageTextRepository.addCollect(uid, iid, pid);
	}

	public boolean isCollect(String uid, String iid) {
		return userCollectImageTextRepository.isCollect(uid, iid);
	}

	public void deleteCollect(String uid, String iid) {
		userCollectImageTextRepository.deleteCollect(uid, iid);
	}

	public int countCollect(String iid) {
		return userCollectImageTextRepository.countCollect(iid);
	}

	public Map<String, Integer> countCollect(Collection<String> iids) {
		return userCollectImageTextRepository.countCollect(iids);
	}

	public int countCollectForUser(String uid) {
		return userCollectImageTextRepository.countCollectForUser(uid);
	}

	public List<UserCollectImageText> getCollectForUser(String uid, int start, int size) {
		return userCollectImageTextRepository.getCollectForUser(uid, start, size);
	}

	public List<String> filterCollectForUser(String uid, Collection<String> iids) {
		return userCollectImageTextRepository.filterCollectForUser(uid, iids);
	}
}
