/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.UploadVideoStatus;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UploadVideo;
import com.jz.jooq.media.tables.records.UploadVideoRecord;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UploadVideoRepository
extends MediaBaseRepository {
    private static final com.jz.jooq.media.tables.UploadVideo UV = Tables.UPLOAD_VIDEO;

    public void saveToWaiting(String wid, String uid, String name, String app) {
        long timeMillis = System.currentTimeMillis();
        this.mediaCtx.insertInto((Table)UV, (Field)UploadVideoRepository.UV.WID, (Field)UploadVideoRepository.UV.UID, (Field)UploadVideoRepository.UV.APP, (Field)UploadVideoRepository.UV.NAME, (Field)UploadVideoRepository.UV.STATUS, (Field)UploadVideoRepository.UV.CREATE_TIME, (Field)UploadVideoRepository.UV.LAST_UPDATE).values((Object)wid, (Object)uid, (Object)app, (Object)name, (Object)UploadVideoStatus.waiting.getCode(), (Object)timeMillis, (Object)timeMillis).onDuplicateKeyIgnore().execute();
    }

    public void updateVideoInfo(UploadVideoRecord record) {
        this.mediaCtx.update((Table)UV).set((Record)record).where(new Condition[]{UploadVideoRepository.UV.WID.eq((Object)record.getWid())}).execute();
    }

    private Condition getWhereCondition(String uid, Collection<UploadVideoStatus> status, BrandEnum brand) {
        List ss = status.stream().map(it -> it.getCode()).collect(Collectors.toList());
        return UploadVideoRepository.UV.STATUS.in(ss).and(UploadVideoRepository.UV.UID.eq((Object)uid)).and(UploadVideoRepository.UV.APP.eq((Object)brand.name()));
    }

    public int countVideos(String uid, Collection<UploadVideoStatus> status, BrandEnum brand) {
        return this.mediaCtx.fetchCount((Table)UV, this.getWhereCondition(uid, status, brand));
    }

    public List<String> getVideos(String uid, Collection<UploadVideoStatus> status, BrandEnum brand, int start, int size) {
        return this.mediaCtx.select((SelectField)UploadVideoRepository.UV.WID).from((TableLike)UV).where(new Condition[]{this.getWhereCondition(uid, status, brand)}).orderBy(UploadVideoRepository.UV.STATUS.desc(), UploadVideoRepository.UV.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
    }

    public List<UploadVideo> getVideoInfo(Collection<String> wids) {
        return this.mediaCtx.selectFrom((Table)UV).where(new Condition[]{UploadVideoRepository.UV.WID.in(wids)}).fetchInto(UploadVideo.class);
    }

    private Condition getOnlineNotUidWhereCondition(String uid, BrandEnum brand) {
        return UploadVideoRepository.UV.STATUS.eq((Object)UploadVideoStatus.online.getCode()).and(UploadVideoRepository.UV.APP.eq((Object)brand.name())).and(UploadVideoRepository.UV.UID.ne((Object)uid));
    }

    public int countOnlineVideosForNotUid(String uid, BrandEnum brand) {
        return this.mediaCtx.fetchCount((Table)UV, this.getOnlineNotUidWhereCondition(uid, brand));
    }

    public List<String> getOnlineVideosForNotUid(String uid, BrandEnum brand, int start, int size) {
        return this.mediaCtx.select((SelectField)UploadVideoRepository.UV.WID).from((TableLike)UV).where(new Condition[]{this.getOnlineNotUidWhereCondition(uid, brand)}).orderBy(UploadVideoRepository.UV.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
    }

    public List<String> getOnlineVideos(String uid, Collection<String> wids) {
        return this.mediaCtx.select((SelectField)UploadVideoRepository.UV.WID).from((TableLike)UV).where(new Condition[]{UploadVideoRepository.UV.WID.in(wids).and(UploadVideoRepository.UV.STATUS.eq((Object)UploadVideoStatus.online.getCode())).and(UploadVideoRepository.UV.UID.eq((Object)uid))}).fetchInto(String.class);
    }

    public void deleteVideos(String uid, Collection<String> wids) {
        this.mediaCtx.deleteFrom((Table)UV).where(new Condition[]{UploadVideoRepository.UV.WID.in(wids).and(UploadVideoRepository.UV.UID.eq((Object)uid))}).execute();
    }

    public UploadVideo getOnlineVideo(String uid, String wid) {
        List videos = this.mediaCtx.selectFrom((Table)UV).where(new Condition[]{UploadVideoRepository.UV.WID.eq((Object)wid).and(UploadVideoRepository.UV.STATUS.eq((Object)UploadVideoStatus.online.getCode())).and(UploadVideoRepository.UV.UID.eq((Object)uid))}).fetchInto(UploadVideo.class);
        return ArrayMapTools.isNotEmpty((Collection)videos) ? (UploadVideo)videos.get(0) : null;
    }

    public List<String> getOnlineVideoIds(String uid) {
        return this.mediaCtx.select((SelectField)UploadVideoRepository.UV.WID).from((TableLike)UV).where(new Condition[]{UploadVideoRepository.UV.STATUS.eq((Object)UploadVideoStatus.online.getCode()).and(UploadVideoRepository.UV.UID.eq((Object)uid))}).fetchInto(String.class);
    }

    public UploadVideo getVideo(String wid) {
        return (UploadVideo)this.mediaCtx.selectFrom((Table)UV).where(new Condition[]{UploadVideoRepository.UV.WID.eq((Object)wid)}).fetchAnyInto(UploadVideo.class);
    }
}

