/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.google.common.collect.Lists;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.UserCoinTaskDay;
import com.jz.jooq.media.tables.UserCoinTaskRecord;
import com.jz.jooq.media.tables.UserCoinTaskSetting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserCoinTaskRepository
extends MediaBaseRepository {
    private static final UserCoinTaskSetting UCTS = Tables.USER_COIN_TASK_SETTING;
    private static final UserCoinTaskRecord UCTR = Tables.USER_COIN_TASK_RECORD;
    private static final UserCoinTaskDay UCTD = Tables.USER_COIN_TASK_DAY;

    public List<com.jz.jooq.media.tables.pojos.UserCoinTaskSetting> listSettings() {
        return this.mediaCtx.selectFrom((Table)UCTS).fetchInto(com.jz.jooq.media.tables.pojos.UserCoinTaskSetting.class);
    }

    public boolean isExistTaskRecord(String uid, String taskId) {
        return this.mediaCtx.fetchExists((Table)UCTR, UserCoinTaskRepository.UCTR.UID.eq((Object)uid).and(UserCoinTaskRepository.UCTR.TASK_ID.eq((Object)taskId)));
    }

    public List<String> mutiGetOnceTaskRecord(String uid, Collection<String> taskIds) {
        return this.mediaCtx.select((SelectField)UserCoinTaskRepository.UCTR.TASK_ID).from((TableLike)UCTR).where(new Condition[]{UserCoinTaskRepository.UCTR.UID.eq((Object)uid).and(UserCoinTaskRepository.UCTR.TASK_ID.in(taskIds))}).fetchInto(String.class);
    }

    public void createTaskRecord(String uid, String taskId, Integer num) {
        this.mediaCtx.insertInto((Table)UCTR, (Field)UserCoinTaskRepository.UCTR.UID, (Field)UserCoinTaskRepository.UCTR.TASK_ID, (Field)UserCoinTaskRepository.UCTR.NUM, (Field)UserCoinTaskRepository.UCTR.CREATED).values((Object)uid, (Object)taskId, (Object)num, (Object)System.currentTimeMillis()).execute();
    }

    public void createTaskDay(String uid, String type, String date, Integer num, Integer taskDays) {
        this.mediaCtx.insertInto((Table)UCTD, (Field)UserCoinTaskRepository.UCTD.UID, (Field)UserCoinTaskRepository.UCTD.TYPE, (Field)UserCoinTaskRepository.UCTD.DATE, (Field)UserCoinTaskRepository.UCTR.NUM, (Field)UserCoinTaskRepository.UCTD.TASK_DAYS, (Field)UserCoinTaskRepository.UCTR.CREATED).values((Object)uid, (Object)type, (Object)date, (Object)num, (Object)taskDays, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public com.jz.jooq.media.tables.pojos.UserCoinTaskDay getTaskDay(String uid, String type, String date) {
        return (com.jz.jooq.media.tables.pojos.UserCoinTaskDay)this.mediaCtx.selectFrom((Table)UCTD).where(new Condition[]{UserCoinTaskRepository.UCTD.UID.eq((Object)uid).and(UserCoinTaskRepository.UCTD.TYPE.eq((Object)type)).and(UserCoinTaskRepository.UCTD.DATE.eq((Object)date))}).fetchAnyInto(com.jz.jooq.media.tables.pojos.UserCoinTaskDay.class);
    }

    public List<com.jz.jooq.media.tables.pojos.UserCoinTaskDay> getRecentTaskDay(String uid, String type, String minDate) {
        return this.mediaCtx.selectFrom((Table)UCTD).where(new Condition[]{UserCoinTaskRepository.UCTD.UID.eq((Object)uid).and(UserCoinTaskRepository.UCTD.TYPE.eq((Object)type)).and(UserCoinTaskRepository.UCTD.DATE.ge((Object)minDate))}).fetchInto(com.jz.jooq.media.tables.pojos.UserCoinTaskDay.class);
    }

    public List<com.jz.jooq.media.tables.pojos.UserCoinTaskDay> mutiGetTaskDay(String uid, List<Pair<String, String>> typeDatePairs) {
        ArrayList conditions = Lists.newArrayList();
        for (Pair<String, String> p : typeDatePairs) {
            conditions.add(UserCoinTaskRepository.UCTD.TYPE.eq(p.getLeft()).and(UserCoinTaskRepository.UCTD.DATE.eq(p.getRight())));
        }
        return this.mediaCtx.selectFrom((Table)UCTD).where(new Condition[]{UserCoinTaskRepository.UCTD.UID.eq((Object)uid).and(DSL.or((Collection)conditions))}).fetchInto(com.jz.jooq.media.tables.pojos.UserCoinTaskDay.class);
    }
}

